<?php
$UniqueName  = "Dashboard";
require($_SERVER['DOCUMENT_ROOT'] . "/accounts/layout/header.php");

if (@!$_SESSION['internetid']) {
    header("location:../login.php");
    die;
}
if (@!$_COOKIE['firstVisit']) {
    setcookie("firstVisit", "no", time() + 3600);
    toast_alert('success', 'Welcome Back ' . $fullName . " !", 'Close');
}

unset($_SESSION['wire_transfer'], $_SESSION['dom_transfer']);
?>

<!--  BEGIN CONTENT PART  -->
<div id="content" class="main-content">
    <div class="layout-px-spacing">
        <br>

        <?php
        if ($temp_trans['trans_status'] == "pending") {
        ?>
            <div class="alert alert-icon-left alert-light-primary mb-4" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <svg data-dismiss="alert">...</svg>
                </button>
                <svg>...</svg>
                <strong>Alert!</strong> You have a pending wire transaction of <?= $currency ?><?php echo number_format($TempBalance, 2, '.', ','); ?>!
                <a href="transfer-pending.php" class="text-danger">Resume Transaction!</a>
            </div>
        <?php } ?>

        <div class="row layout-top-spacing">

            <!-- Account Overview Card -->
            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
                <div class="widget widget-account-invoice-three">
                    <div class="widget-heading">
                        <div class="wallet-usr-info">
                            <div class="usr-name">
                                <span>
                                    <img src="<?= $web_url ?>/ui/assets/img/<?= $row['acct_image'] ?>" alt="" class="img-fluid">
                                    <?= $fullName ?>
                                </span>
                            </div>
                            <div class="add">
                                <a href="./helpdesk.php">
                                    <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" stroke="currentColor"
                                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-plus">
                                            <line x1="12" y1="5" x2="12" y2="19"></line>
                                            <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>
                        <div class="wallet-balance">
                            <p>Balance</p>
                            <h5><?= $currency ?><?php echo number_format($TotalBalance, 2, '.', ','); ?></h5>
                        </div>
                    </div>

                    <div class="widget-amount">
                        <div class="w-a-info funds-received">
                            <span>Inflow 
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-chevron-down">
                                    <polyline points="6 9 12 15 18 9"></polyline>
                                </svg>
                            </span><br>
                            <?php
                            $sql = "SELECT SUM(amount) FROM transactions WHERE transaction_type='credit' AND internetid=:internetid";
                            $stmt = $conn->prepare($sql);
                            $stmt->execute([':internetid' => $_SESSION['internetid']]);
                            $Inflow = $stmt->fetchColumn();
                            ?>
                            <span class="text-success"><?= $currency ?><?php echo number_format($Inflow, 2, '.', ','); ?></span>
                        </div>

                        <div class="w-a-info funds-spent">
                            <span>Outflow 
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-chevron-up">
                                    <polyline points="18 15 12 9 6 15"></polyline>
                                </svg>
                            </span><br>
                            <?php
                            $sql = "SELECT SUM(amount) FROM transactions WHERE transaction_type='debit' AND internetid=:internetid";
                            $stmt = $conn->prepare($sql);
                            $stmt->execute([':internetid' => $_SESSION['internetid']]);
                            $Outflow = $stmt->fetchColumn();
                            ?>
                            <span class="text-danger"><?= $currency ?><?php echo number_format($Outflow, 2, '.', ','); ?></span>
                        </div>
                    </div>

                    <div class="widget-content">
                        <div class="invoice-list">
                            <div class="inv-detail">
                                <div class="info-detail-2">
                                    <p>Loan Balance: </p>
                                    <p><span class="bill-amount text-secondary"><?= $currency ?><?php echo number_format($LoanBalance, 2, '.', ','); ?></span></p>
                                </div>

                                <div class="info-detail-2">
                                    <p>Savings Balance: </p>
                                    <p><span class="bill-amount text-info"><?= $currency ?><?php echo number_format($SavingsBalance, 2, '.', ','); ?></span></p>
                                </div>

                                <div class="info-detail-2">
                                    <p>Current Balance: </p>
                                    <p><span class="bill-amount text-info"><?= $currency ?><?php echo number_format($CurrentBalance, 2, '.', ','); ?></span></p>
                                </div>
                            </div>

                            <div class="inv-action">
                                <a href="./history.php" class="btn btn-outline-primary view-details">View Details</a>
                                <a href="./my-account.php" class="btn btn-outline-primary pay-now">Account Details</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transactions Section -->
            <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                <div class="widget widget-table-one">
                    <div class="widget-heading">
                        <h5>Transactions</h5>
                        <div class="task-action">
                            <div class="dropdown">
                                <a class="dropdown-toggle" href="#" role="button" id="pendingTask" data-toggle="dropdown">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-more-horizontal">
                                        <circle cx="12" cy="12" r="1"></circle>
                                        <circle cx="19" cy="12" r="1"></circle>
                                        <circle cx="5" cy="12" r="1"></circle>
                                    </svg>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a class="dropdown-item" href="./history.php">View All</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="widget-content">
                        <?php
                        $sql2 = "SELECT * FROM transactions WHERE internetid=:internetid ORDER BY trans_id DESC LIMIT 6";
                        $wire5 = $conn->prepare($sql2);
                        $wire5->execute([':internetid' => $_SESSION['internetid']]);
                        while ($result4 = $wire5->fetch(PDO::FETCH_ASSOC)) {
                            $TempBalance2 = $result4['amount'];
                            $timeOnly = date("h:i A", strtotime($result4['created_at'])); // format to show time only

                            if ($result4['transaction_type'] === 'credit') {
                        ?>
                                <div class="transactions-list t-info">
                                    <div class="t-item">
                                        <div class="t-company-name">
                                            <div class="t-icon"><div class="avatar avatar-xl"><span class="avatar-title">+</span></div></div>
                                            <div class="t-name">
                                                <h4><?= $result4['trans_type']; ?></h4>
                                                <p class="meta-date"><?= $timeOnly; ?></p>
                                            </div>
                                        </div>
                                        <div class="t-rate rate-inc">
                                            <p><span>+<?= $currency ?><?php echo number_format($TempBalance2, 2, '.', ','); ?></span></p>
                                        </div>
                                    </div>
                                </div>
                            <?php } else { ?>
                                <div class="transactions-list">
                                    <div class="t-item">
                                        <div class="t-company-name">
                                            <div class="t-icon"><div class="avatar avatar-xl"><span class="avatar-title">-</span></div></div>
                                            <div class="t-name">
                                                <h4><?= $result4['trans_type']; ?></h4>
                                                <p class="meta-date"><?= $timeOnly; ?></p>
                                            </div>
                                        </div>
                                        <div class="t-rate rate-dec">
                                            <p><span>-<?= $currency ?><?php echo number_format($TempBalance2, 2, '.', ','); ?></span></p>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <!-- Statistics Section -->
            <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12 layout-spacing">
                <div class="widget widget-one">
                    <div class="widget-heading">
                        <h6>Statistics</h6>
                    </div>
                    <div class="w-chart">
                        <div class="w-chart-section total-visits-content">
                            <div class="w-detail">
                                <p class="w-title">Total Visits</p>
                                <p class="w-stats">423,964</p>
                            </div>
                        </div>
                        <div class="w-chart-section paid-visits-content">
                            <div class="w-detail">
                                <p class="w-title">Paid Visits</p>
                                <p class="w-stats">7,929</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Account info cards -->
            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
                <div class="widget widget-card-four">
                    <div class="widget-content">
                        <div class="w-header">
                            <div class="w-info">
                                <h6 class="value">Current Account</h6>
                            </div>
                        </div>
                        <div class="w-content">
                            <div class="w-info">
                                <p class="value">(<?= $row['current_acctno'] ?>)</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
                <div class="widget widget-card-four">
                    <div class="widget-content">
                        <div class="w-header">
                            <div class="w-info">
                                <h6 class="value">Savings Account</h6>
                            </div>
                        </div>
                        <div class="w-content">
                            <div class="w-info">
                                <p class="value">(<?= $row['savings_acctno'] ?>)</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- end row -->
    </div> <!-- end layout -->

    <?php require($_SERVER['DOCUMENT_ROOT'] . "/accounts/layout/footer.php"); ?>
</div>
